extends Node2D

# --- State Machine ---
enum State { MENU, COUNTDOWN, PLAYING, DYING, SCORE }
var current_state = State.MENU

# --- Game Data ---
var score = 0
var pipe_scene = preload("res://prefabs/pipe_pair.tscn")

# --- Gap Settings ---
const PIPE_GAP = 80       # Vertical gap between top and bottom pipes
const PIPE_MARGIN = 20    # Min distance from viewport top / ground
const PIPE_Y_MIN = PIPE_MARGIN + PIPE_GAP / 2 - 144   # -84
const PIPE_Y_MAX = 280 - PIPE_MARGIN - PIPE_GAP / 2 - 144  # 76
const MAX_PIPE_SHIFT = 60 # Max Y change between consecutive pipes

var last_pipe_y = 0.0

func _ready():
	$Bird.area_entered.connect(_on_bird_area_entered)
	$PipeSpawnTimer.timeout.connect(_on_pipe_spawn_timer_timeout)
	$Sound/Music.play()
	#show_menu()

# === TODO 6: State Machine ===
# In _process(delta), use if/elif to check current_state:
#   State.MENU: if "flap" just pressed -> call start_countdown()
#   State.COUNTDOWN: (countdown runs itself via await)
#   State.PLAYING: (bird and pipes update themselves)
#   State.DYING: (freeze runs itself via await)
#   State.SCORE: if "flap" just pressed -> call restart()
func _process(_delta):
	# === TODO 6: State Machine ===
	pass

# === TODO 4: Pipe Spawning ===
# Called when PipeSpawnTimer fires
# Create a new pipe_scene instance, set gap, place at x=550
# Clamp Y so the gap stays within viewport margins
# Limit Y shift from last pipe for a smooth path
# Add it to the scene with add_child()
# Add the pipe to the "pipe_pairs" group
func _on_pipe_spawn_timer_timeout():
	# === TODO 4: Pipe Spawning ===
	pass

# === TODO 5: Collision Handling ===
# Called when the bird enters any Area2D
# If area is in group "pipe" -> call game_over()
# If area is in group "score_zone" -> increment score, update label, free the zone
func _on_bird_area_entered(area):
	# === TODO 5: Collision Handling ===
	pass

func start_countdown():
	current_state = State.COUNTDOWN
	$ReadyLabel.text = "3"
	await get_tree().create_timer(1.0).timeout
	$ReadyLabel.text = "2"
	await get_tree().create_timer(1.0).timeout
	$ReadyLabel.text = "1"
	await get_tree().create_timer(1.0).timeout
	$ReadyLabel.visible = false
	start_game()

func start_game():
	current_state = State.PLAYING
	score = 0
	$ScoreLabel.text = "0"
	$Bird.alive = true
	$PipeSpawnTimer.start()

func game_over():
	current_state = State.DYING
	$Bird.die()
	$PipeSpawnTimer.stop()
	$Sound/HitSound.play()
	$Background.set_process(false)
	$Ground.set_process(false)
	get_tree().call_group("pipe_pairs", "set_process", false)
	await get_tree().create_timer(1.0).timeout
	show_score_screen()

func show_score_screen():
	current_state = State.SCORE
	$GameOverLabel.text = "Score: " + str(score) + "\nPress Space to Continue"
	$GameOverLabel.visible = true

func restart():
	$GameOverLabel.visible = false
	get_tree().call_group("pipe_pairs", "queue_free")
	$Bird.reset()
	last_pipe_y = 0.0
	$Background.set_process(true)
	$Ground.set_process(true)
	show_menu()

func show_menu():
	current_state = State.MENU
	$Bird.alive = false
	$ReadyLabel.text = "Press Space to Start"
	$ReadyLabel.visible = true
	$ScoreLabel.text = "0"
	score = 0
