extends Area2D

# --- Constants ---
const GRAVITY = 800
const FLAP_STRENGTH = -250
const MAX_FALL_SPEED = 400

# --- State ---
var velocity = Vector2.ZERO
var alive = true

func _process(delta):
	if not alive:
		return

	# === TODO 1: Gravity ===
	# Add GRAVITY to velocity.y (scaled by delta)
	# Clamp velocity.y so the bird doesn't fall faster than MAX_FALL_SPEED
	# Move the bird: position.y += velocity.y * delta
	velocity.y += GRAVITY * delta
	velocity.y = clamp(velocity.y, -MAX_FALL_SPEED, MAX_FALL_SPEED)
	position.y += velocity.y * delta

	# === TODO 2: Flap ===
	# If the "flap" action was just pressed, set velocity.y to FLAP_STRENGTH
	if Input.is_action_just_pressed("flap"):
		velocity.y = FLAP_STRENGTH
		get_parent().get_node("Sound/FlapSound").play()

	# Visual: tilt bird based on velocity
	rotation = clamp(velocity.y / 400.0, -0.5, 1.0)

func die():
	alive = false
	# Bird tumbles on death
	rotation = 1.2

func reset():
	position = Vector2(256, 144)
	velocity = Vector2.ZERO
	rotation = 0
	alive = true
