extends Area2D

# TODO: Define a custom signal called "scored" that takes a player number
# Hint: signal scored(player)

var velocity = Vector2.ZERO
var speed = 400

func _ready():
	reset()

func reset():
	position = Vector2(400, 300)
	# Random direction: left or right, slight vertical angle
	var direction = Vector2([-1, 1].pick_random(), randf_range(-0.5, 0.5))
	velocity = direction.normalized() * speed

func _process(delta):
	# Move the ball (Ricochet pattern)
	position = position + velocity * delta

	# Top and bottom wall bounce (Ricochet pattern)
	if position.y < 10 or position.y > 590:
		velocity.y = -velocity.y

	# TODO: Add scoring detection
	# When ball goes past left edge (x < 0): Player 2 scores
	#   - Emit the scored signal with value 2
	#   - Call reset()
	# When ball goes past right edge (x > 800): Player 1 scores
	#   - Emit the scored signal with value 1
	#   - Call reset()
	pass

func _on_area_entered(area):
	# TODO: Complete the paddle collision handler
	# 1. Check if the area is in the "paddle" group using is_in_group()
	# 2. Reverse velocity.x (horizontal bounce)
	# 3. Nudge ball away from paddle to prevent double-hit:
	#    position.x = position.x + sign(velocity.x) * 10
	# 4. Calculate angle based on where ball hit the paddle:
	#    var hit_offset = (position.y - area.position.y) / 50
	#    velocity.y = hit_offset * speed * 0.75
	# 5. Maintain consistent speed:
	#    velocity = velocity.normalized() * speed
	# 6. (Optional) Play hit sound:
	#    get_parent().get_node("HitSound").play()
	pass
