extends Node2D

var fruit_scene = preload("res://prefabs/fruit.tscn")  # load once at startup
var score = 0

func _ready():
	$SpawnTimer.wait_time = 1.0       # spawn every 1 second
	$SpawnTimer.start()               # begin the countdown
	$SpawnTimer.timeout.connect(_on_spawn_timer_timeout)  # signal → function

func _on_spawn_timer_timeout():
	var fruit = fruit_scene.instantiate()         # create a new fruit
	var screen_w = get_viewport_rect().size.x     # viewport width
	var margin = 50                               # edge padding
	fruit.position = Vector2(randf_range(margin, screen_w - margin), -20)  # random x, above screen
	add_child(fruit)                              # add to scene → starts falling

func add_score():                                 # called by Basket on catch
	score = score + 1
	$ScoreLabel.text = "Score: " + str(score)     # update the UI
