extends Area2D

var speed = 200

# Called when the node enters the scene tree for the first time.
func _ready() -> void:
	add_to_group("fruits")
	$Sprite2D.modulate = Color(randf(), randf(), randf())
	# Random fall speed
	speed = randf_range(150, 350)


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	position.y = position.y + speed * delta                              # fall downward

	var half_h = $Sprite2D.texture.get_height() * $Sprite2D.scale.y / 2 # display half-height
	var screen_h = get_viewport_rect().size.y                           # viewport height
	if position.y > screen_h + half_h:                                  # fully below screen?
		queue_free()                                                    # destroy this frui
