extends Area2D

var speed = 400

# Called when the node enters the scene tree for the first time.
func _ready() -> void:
	pass # Replace with function body.


func _physics_process(delta):
	if Input.is_action_pressed("ui_left"):
		position.x = position.x - speed * delta
	if Input.is_action_pressed("ui_right"):
		position.x = position.x + speed * delta

	# Half the sprite's display width (texture × scale)
	var half_w = $Sprite2D.texture.get_width() * $Sprite2D.scale.x / 2
	# The viewport's width in pixels
	var screen_w = get_viewport_rect().size.x
	# Clamp so the sprite's edges never leave the screen
	position.x = clamp(position.x, half_w, screen_w - half_w)


func _on_area_entered(area: Area2D) -> void:
	if area.is_in_group("fruits"):
		area.queue_free()
		print("Collision detected")
		# Tell the game we scored
		var game = get_parent()
		game.add_score()
