extends Node2D

var SPEED = 300					# pixels per second
var direction = Vector2(0,0)	# random direction to begin with

# Called when the node enters the scene tree for the first time.
func _ready():
	direction = Vector2(randf_range(-1, 1), randf_range(-1, 1)).normalized()


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	var screen_size = get_viewport_rect().size
	var sprite_width = 128
	var sprite_height = 128
	
	position += direction * SPEED * delta
	
	# Bounce off walls
	var bounced = false
	if position.x > screen_size.x - sprite_width/2 or position.x < sprite_width/2:
		direction.x = -direction.x
		bounced = true
	if position.y > screen_size.y - sprite_height/2 or position.y < sprite_height/2:
		bounced = true
		
	if bounced:
		$Sprite2D.modulate = Color(randf(), randf(), randf())
		direction.y = -direction.y
