extends Node2D

var speed = 300.0

# Called when the node enters the scene tree for the first time.
func _ready() -> void:
	pass # Replace with function body.


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta: float) -> void:
	var direction = Vector2.ZERO
	
	if Input.is_action_pressed("ui_right"):
		direction.x += 1
	if Input.is_action_pressed("ui_left"):
		direction.x -= 1
	if Input.is_action_pressed("ui_up"):
		direction.y -= 1
	if Input.is_action_pressed("ui_down"):
		direction.y += 1
	
	if direction.length() > 0:
		direction = direction.normalized()
		
	position += direction * speed * delta

	var screen_size = get_viewport_rect().size
	position.x = clamp(position.x, 64, screen_size.x-64)
	position.y = clamp(position.y, 64, screen_size.y-64)

	
	
	
