# analyzer.py — Recursive Text Analyzer
# All functions must be recursive. No loops allowed!


def char_count(s):
    """Count total characters (like len, but recursive).
    Example: char_count("hello") returns 5
             char_count("") returns 0
    """
    pass  # TODO


def word_count(s):
    """Count words (split by spaces).
    Example: word_count("hello world") returns 2
             word_count("one") returns 1
             word_count("") returns 0
    Hint: strip whitespace first, then find the first space using find_char.
    """
    pass  # TODO


def find_char(s, c):
    """Find index of character c in string s. Return -1 if not found.
    Use a nested helper function with an index parameter.
    Example: find_char("hello", "e") returns 1
             find_char("hello", "z") returns -1
    """
    def helper(index):
        pass  # TODO
    return helper(0)


def clean_text(s):
    """Remove all non-letter, non-space characters and lowercase everything.
    Example: clean_text("Hello, World!") returns "hello world"
             clean_text("abc123") returns "abc"
    """
    pass  # TODO


def is_palindrome_phrase(s):
    """Check if a phrase is a palindrome (ignoring spaces/punctuation).
    Use clean_text to clean the string, then a helper with left/right indices.
    Example: is_palindrome_phrase("racecar") returns True
             is_palindrome_phrase("A man a plan a canal Panama") returns True
             is_palindrome_phrase("hello") returns False
    """
    cleaned = clean_text(s).replace(" ", "")
    def helper(left, right):
        pass  # TODO
    return helper(0, len(cleaned) - 1)


def most_common(s):
    """Find the most common letter (lowercase, ignoring spaces).
    Example: most_common("aabbc") returns "a"
             most_common("hello") returns "l"
    Hint: you'll need two recursive helpers:
      - count_in(text, c): count how many times c appears in text
      - best(text, current_best, best_count): scan through text
        tracking the character with the highest count
    """
    cleaned = clean_text(s).replace(" ", "")
    if cleaned == "":
        return ""

    def count_in(text, c):
        pass  # TODO

    def best(text, current_best, best_count):
        pass  # TODO

    return best(cleaned, cleaned[0], 0)
