# sum_digits.py
def sum_digits(n):
    # W: What's the simplest case?
    #    A single digit is its own sum.
    if n < 10:
        return n

    # I: If not simple, shrink it.
    #    Remove the last digit: n // 10
    # S: Solve the smaller problem.
    #    sum_digits(n // 10) gives the sum of the remaining digits.
    # E: Extend to full answer.
    #    Add the last digit (n % 10) to the smaller sum.
    return (n % 10) + sum_digits(n // 10)

print(sum_digits(123))     # 6   (1 + 2 + 3)
print(sum_digits(9))       # 9   (single digit)
print(sum_digits(4507))    # 16  (4 + 5 + 0 + 7)
