# string_recursion.py

def count_vowels(s):
    """Count vowels in a string recursively."""
    if s == "":
        return 0
    rest = count_vowels(s[1:])
    if s[0].lower() in "aeiou":
        return 1 + rest
    return rest

def remove_char(s, c):
    """Remove all occurrences of character c from string s."""
    if s == "":
        return ""
    rest = remove_char(s[1:], c)
    if s[0] == c:
        return rest
    return s[0] + rest

# Test count_vowels
print(count_vowels("banana"))    # 3
print(count_vowels("HELLO"))     # 2
print(count_vowels("xyz"))       # 0

# Test remove_char
print(remove_char("hello", "l"))     # "heo"
print(remove_char("banana", "a"))    # "bnn"
print(remove_char("aaa", "a"))       # ""
