# helper_demo.py

# Version 1: Slicing (simple but slow for large lists)
def count_target_slice(lst, t):
    if lst == []:
        return 0
    match = 1 if lst[0] == t else 0
    return match + count_target_slice(lst[1:], t)

# Version 2: Helper function (efficient, no copies)
def count_target(lst, t):
    def helper(index):
        if index == len(lst):
            return 0
        match = 1 if lst[index] == t else 0
        return match + helper(index + 1)
    return helper(0)

# Both give the same answer
print(count_target_slice([1, 3, 1, 2, 1], 1))   # 3
print(count_target([1, 3, 1, 2, 1], 1))          # 3
