# exercises_sec7.py — Helper Functions and Avoiding Slicing
# Rewrite functions using a nested helper with an index parameter
# instead of slicing. No loops allowed!


def product_list(lst):
    """Compute the product of all elements using a helper with an index.
    (Rewrite of the Section 6 walkthrough, but without slicing.)
    Example: product_list([2, 5, 3, 4]) returns 120
    """
    def helper(index):
        pass  # TODO
    return helper(0)


def count_vowels_helper(s):
    """Count vowels in a string using a helper with an index
    instead of s[1:] slicing.
    Example: count_vowels_helper("banana") returns 3
    """
    def helper(index):
        pass  # TODO
    return helper(0)


def linear_search(lst, target):
    """Return the index of target in lst, or -1 if not found.
    Use a helper that carries the current index.
    Example: linear_search([10, 20, 30], 20) returns 1
             linear_search([10, 20, 30], 50) returns -1
    """
    def helper(index):
        pass  # TODO
    return helper(0)


def is_palindrome_helper(s):
    """Check if a string is a palindrome using a helper with two indices:
    left starting at 0 and right starting at len(s) - 1.
    Example: is_palindrome_helper("racecar") returns True
             is_palindrome_helper("hello") returns False
    """
    def helper(left, right):
        pass  # TODO
    return helper(0, len(s) - 1)


def binary_search(lst, target):
    """Search a SORTED list for target. Return its index or -1 if not found.
    Use a helper with low and high parameters.
    Example: binary_search([1, 3, 5, 7, 9], 7) returns 3
             binary_search([1, 3, 5, 7, 9], 4) returns -1
    """
    def helper(low, high):
        pass  # TODO
    return helper(0, len(lst) - 1)


# ── Test your functions ──────────────────────────────────────
if __name__ == "__main__":
    print("--- product_list ---")
    print(product_list([2, 5, 3, 4]))   # 120
    print(product_list([7]))            # 7

    print("\n--- count_vowels_helper ---")
    print(count_vowels_helper("banana"))   # 3
    print(count_vowels_helper("HELLO"))    # 2
    print(count_vowels_helper("xyz"))      # 0

    print("\n--- linear_search ---")
    print(linear_search([10, 20, 30], 20))   # 1
    print(linear_search([10, 20, 30], 50))   # -1
    print(linear_search([10, 20, 30], 10))   # 0

    print("\n--- is_palindrome_helper ---")
    print(is_palindrome_helper("racecar"))   # True
    print(is_palindrome_helper("hello"))     # False
    print(is_palindrome_helper("a"))         # True

    print("\n--- binary_search ---")
    print(binary_search([1, 3, 5, 7, 9], 7))   # 3
    print(binary_search([1, 3, 5, 7, 9], 4))   # -1
    print(binary_search([1, 3, 5, 7, 9], 1))   # 0
    print(binary_search([1, 3, 5, 7, 9], 9))   # 4
