# exercises_sec4.py — Debugging Recursive Functions
# Fix the bugs and write the debug_product function.


# ── Exercise 4: Fix the bug ─────────────────────────────────
# This function is supposed to count vowels but has a bug.
# Find and fix it, then uncomment the test calls at the bottom.
def count_vowels_buggy(s):
    if s == "":
        return 0
    if s[0] in "aeiouAEIOU":
        return 1 + count_vowels_buggy(s)    # BUG! What's wrong here?
    return count_vowels_buggy(s[1:])


# ── Exercise 5: Fix the bug ─────────────────────────────────
# This function checks if all characters are uppercase.
# Find and fix the bug.
def all_upper_buggy(s):
    if s == "":
        return True
    if not s[0].isupper():
        return False
    all_upper_buggy(s[1:])    # BUG! What's missing?


# ── Exercise 6: debug_product ───────────────────────────────
def debug_product(lst, depth=0):
    """Compute the product of all elements in lst while printing
    indented trace output (like the depth tracing walkthrough).

    Example: debug_product([2, 3, 5]) should print:
      debug_product([2, 3, 5])
        debug_product([3, 5])
          debug_product([5])
            -> base case, returning 5
          -> returning 15
        -> returning 30
      -> returning 30
    and return 30.
    """
    pass  # TODO


# ── Exercise 7: Fix the bug ─────────────────────────────────
# This function flattens a nested list but has a bug.
# Find and fix it.
def flatten_buggy(lst):
    if lst == []:
        return []
    first = lst[0]
    rest = flatten_buggy(lst[1:])
    if isinstance(first, list):
        return flatten_buggy(first) + rest
    else:
        return first + rest    # BUG! Can you concatenate an int with a list?


# ── Test your fixes ──────────────────────────────────────────
if __name__ == "__main__":
    # Uncomment these after fixing each function:

    # print("--- count_vowels (fixed) ---")
    # print(count_vowels_buggy("hello"))   # 2
    # print(count_vowels_buggy("AEIOU"))   # 5

    # print("\n--- all_upper (fixed) ---")
    # print(all_upper_buggy("HELLO"))    # True
    # print(all_upper_buggy("HeLLO"))    # False
    # print(all_upper_buggy(""))         # True

    print("\n--- debug_product ---")
    print(f"Result: {debug_product([2, 3, 5])}")   # 30

    # print("\n--- flatten (fixed) ---")
    # print(flatten_buggy([1, [2, 3], [4, [5, 6]]]))   # [1, 2, 3, 4, 5, 6]
